/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.worldtracker;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.worldtracker.CapabilityWorldTracker;
import net.dries007.tfc.api.capability.worldtracker.CollapseData;
import net.dries007.tfc.api.util.FallingBlockManager;
import net.dries007.tfc.client.TFCSounds;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class WorldTracker
implements ICapabilitySerializable<NBTTagCompound> {
    private static final Random RANDOM = new Random();
    private final List<CollapseData> collapsesInProgress = new ArrayList<CollapseData>();

    public void addCollapseData(CollapseData collapse) {
        this.collapsesInProgress.add(collapse);
    }

    public void tick(World world) {
        if (!world.field_72995_K && !this.collapsesInProgress.isEmpty() && RANDOM.nextInt(20) == 0) {
            for (CollapseData collapse2 : this.collapsesInProgress) {
                ObjectOpenHashSet updatedPositions = new ObjectOpenHashSet();
                for (BlockPos posAt : collapse2.nextPositions) {
                    IBlockState stateAt = world.func_180495_p(posAt);
                    FallingBlockManager.Specification specAt = FallingBlockManager.getSpecification(stateAt);
                    if (specAt == null || !specAt.isCollapsable() || !FallingBlockManager.canFallThrough(world, posAt.func_177977_b(), Material.field_151576_e) || !specAt.canCollapse(world, posAt) || !(posAt.func_177951_i((Vec3i)collapse2.centerPos) < collapse2.radiusSquared) || !((double)RANDOM.nextFloat() < ConfigTFC.General.FALLABLE.propagateCollapseChance)) continue;
                    IBlockState fallState = specAt.getResultingState(stateAt);
                    world.func_175656_a(posAt, fallState);
                    FallingBlockManager.checkFalling(world, posAt, fallState, true);
                    updatedPositions.add(posAt.func_177984_a());
                }
                collapse2.nextPositions.clear();
                if (updatedPositions.isEmpty()) continue;
                world.func_184133_a(null, collapse2.centerPos, TFCSounds.ROCK_SLIDE_SHORT, SoundCategory.BLOCKS, 0.6f, 1.0f);
                collapse2.nextPositions.addAll((Collection<BlockPos>)updatedPositions);
                collapse2.radiusSquared *= 0.8;
            }
            this.collapsesInProgress.removeIf(collapse -> collapse.nextPositions.isEmpty());
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (CollapseData collapse : this.collapsesInProgress) {
            list.func_74742_a((NBTBase)collapse.serializeNBT());
        }
        nbt.func_74782_a("collapsesInProgress", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.collapsesInProgress.clear();
            NBTTagList list = nbt.func_150295_c("collapsesInProgress", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.collapsesInProgress.add(new CollapseData(list.func_150305_b(i)));
            }
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing enumFacing) {
        return capability == CapabilityWorldTracker.CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing enumFacing) {
        return (T)(this.hasCapability(capability, enumFacing) ? this : null);
    }
}

